% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_multiview.R
\name{brainview.sd}
\alias{brainview.sd}
\title{Visualize a list of colored meshes from a single defined angle.}
\usage{
brainview.sd(coloredmeshes, view_angle, background = "white",
  skip_all_na = TRUE, style = "default", rgloptions = list(),
  rglactions = list(), draw_colorbar = FALSE)
}
\arguments{
\item{coloredmeshes, }{list of coloredmesh. A coloredmesh is a named list as returned by the `coloredmesh.from*` functions (like \code{\link[fsbrain]{coloredmesh.from.morph.native}}). It has the entries 'mesh' of type tmesh3d, a 'col', which is a color specification for such a mesh. Note that the `vis*` functions (like \code{\link[fsbrain]{vis.subject.morph.native}}) all return a list of coloredmeshes.}

\item{view_angle}{character string, the view angle. One of 'lateral_lh', 'dorsal', 'lateral_rh', 'medial_lh', 'ventral', 'medial_rh', 'rostral' or 'caudal'. See \code{\link[fsbrain]{get.view.angle.names}}.}

\item{background}{string, background color passed to \code{\link[rgl]{bg3d}}.}

\item{skip_all_na}{logical, whether to skip (i.e., not render) meshes in the list that have the property 'morph_data_was_all_na' set to TRUE. Defaults to TRUE. Practically, this means that a hemisphere for which the data was not given is not rendered, instead of being rendered in a single color.}

\item{style, }{a named list of style parameters or a string specifying an available style by name (e.g., 'shiny'). Defaults to 'default', the default style.}

\item{rgloptions, }{named list. Parameters passed to \code{\link[rgl]{par3d}}. Defaults to the empty list. To increase plot resolution to 2000x1600 px, try: \code{rgloptions=list("windowRect"=c(50,50,2000,1600))}.}

\item{rglactions, }{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action.}

\item{draw_colorbar}{logical, whether to draw a colorbar. WARNING: The colorbar is drawn to a subplot, and this only works if there is enough space for it. You will have to increase the plot size using the 'rlgoptions' parameter for the colorbar to show up. Defaults to FALSE.}
}
\description{
Visualize a list of colored meshes from a single defined angle.
}
\keyword{internal}
