% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph_agg.R
\name{group.multimorph.agg.standard}
\alias{group.multimorph.agg.standard}
\title{Aggregate standard space (fsaverage) morphometry data for multiple measures over hemispheres for a group of subjects.}
\usage{
group.multimorph.agg.standard(subjects_dir, subjects_list, measures, hemis,
  fwhm, agg_fun = mean, template_subject = "fsaverage",
  format = "mgh", cast = TRUE)
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subjects_list, }{string vector. A vector of subject identifiers that match the directory names within subjects_dir.}

\item{measures, }{vector of strings. Names of the vertex-wise morphometry measures. E.g., c("area", "thickness"). Used to construct the names of the morphometry file to be loaded.}

\item{hemis, }{string, one of 'lh', 'rh' or 'both'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded.}

\item{fwhm, }{string. Smoothing as string, e.g. '10' or '25'.}

\item{agg_fun, }{function. An R function that aggregates data, typically max, mean, min or something similar. Note: this is NOT a string, put the function name without quotes. Defaults to mean.}

\item{template_subject, }{string. Template subject name, defaults to 'fsaverage'.}

\item{format, }{string. One of 'mgh', 'mgz', 'curv'. Defaults to 'mgh'.}

\item{cast, }{Whether a separate 'hemi' column should exist.}
}
\value{
dataframe with aggregated values over all measures and hemis for all subjects, with m columns and n rows, where n is the number of subjects. The m columns are 'subject_id' and '<hemi>.<measure>' (e.g., "lh.thickness") for all combinations of hemi and measure, the latter contains the aggregated data.
}
\description{
Compute the mean (or other aggregates) over all vertices of a subject from standard space morphometry data (like 'surf/lh.area.fwhm10.fsaverage.mgh'). You can specify several measures and hemispheres. Uses knowledge about the FreeSurfer directory structure to load the correct files.
}
\seealso{
Other global aggregation functions: \code{\link{group.morph.agg.native}},
  \code{\link{group.morph.agg.standard}},
  \code{\link{group.multimorph.agg.native}}
}
\concept{global aggregation functions}
