% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.data.on.subject}
\alias{vis.data.on.subject}
\title{Visualize arbitrary data on the surface of any subject.}
\usage{
vis.data.on.subject(subjects_dir, vis_subject_id, morph_data_lh,
  morph_data_rh, surface = "white", colormap = squash::jet,
  views = c("t4"), rgloptions = list())
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, containing the subdir of vis_subject_id, the subject that you want to use for visualization.}

\item{vis_subject_id, }{string. The subject identifier from which to obtain the surface for data visualization. Example: 'fsaverage'.}

\item{morph_data_lh, }{numeric vector or NULL, the data to visualize on the left hemisphere surface. Must have the same length as the surface of the vis_subject_id has vertices. If NULL, this surface will not be rendered. Only one of morph_data_lh or morph_data_rh is allowed to be NULL.}

\item{morph_data_rh, }{numeric vector or NULL, the data to visualize on the right hemisphere surface. Must have the same length as the surface of the vis_subject_id has vertices. If NULL, this surface will not be rendered. Only one of morph_data_lh or morph_data_rh is allowed to be NULL.}

\item{surface, }{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{colormap, }{a colormap. See the squash package for some colormaps. Defaults to squash::jet.}

\item{views, }{list of strings. Valid entries include: 'si': single interactive view. 't4': tiled view showing the brain from 4 angles. 't9': tiled view showing the brain from 9 angles.}

\item{rgloptions}{option list passed to [rgl::par3d()]. Example: rgloptions = list("windowRect"=c(50,50,1000,1000));}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization.
}
\description{
Creates a surface mesh, applies a colormap transform the morphometry data values into colors, and renders the resulting colored mesh in an interactive window. If hemi is 'both', the data is rendered for the wholw brain.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   morph_data_lh = subject.morph.native(subjects_dir, 'subject1', 'thickness', 'lh');
   morph_data_rh = NULL;
   vis.data.on.subject(subjects_dir, 'subject1', morph_data_lh, morph_data_rh);
}

}
\seealso{
Other visualization functions: \code{\link{vis.data.on.fsaverage}},
  \code{\link{vis.subject.annot}},
  \code{\link{vis.subject.morph.native}}
}
\concept{visualization functions}
