\name{coef.summary.frontier}
\alias{coef.summary.frontier}
\title{coef method for class summary.frontier}

\description{
Extract the coefficients, their standard errors, t-values, and P-values
from stochastic frontier models returned by the \code{summary} method
for objects of class \code{frontier}.
}

\usage{
\method{coef}{summary.frontier}( object, which = "mle", \dots )
}

\arguments{
   \item{object}{an object of class \code{\link{summary.frontier}}
      (returned by the \code{summary} method for objects
      of class \code{frontier}}
   \item{which}{character string. Which coefficients should be returned?
      ('ols' for coefficients estimated by OLS
      or 'mle' for coefficients estimated by Maximum Likelihood).}
   \item{\dots}{currently unused.}
}

\value{
   The \code{coef} method for objects of class \code{summary.frontier} 
   returns a matrix,
   where the four columns contain the estimated
   coefficients, their standard errors, t-values, and P-values.
}

\author{Arne Henningsen}

\examples{
   # example included in FRONTIER 4.1
   data( front41Data )

   sfaResult <- sfa( log( output ) ~ log( capital ) + log( labour ),
      data = front41Data )
   coef( summary( sfaResult ), which = "ols" )
   coef( summary( sfaResult ) )
}

\keyword{models}
