% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_difftime_less.R
\name{is_difftime_less}
\alias{is_difftime_less}
\title{Check Whether Two Times Differ Less Than A Given Value}
\usage{
is_difftime_less(
  time1,
  time2,
  less_than = 1,
  units = "days",
  verbose = FALSE,
  visible = !verbose,
  stop_on_error = FALSE
)
}
\arguments{
\item{time1}{See \code{\link{difftime}}.}

\item{time2}{See \code{\link{difftime}}.}

\item{less_than}{The number of \bold{units} that would be too much of a
difference.}

\item{units}{See \code{\link{difftime}}.}

\item{verbose}{Be verbose?}

\item{visible}{Set to \code{\link{FALSE}} to return
\code{\link{invisible}}.}

\item{stop_on_error}{Throw an error if the time lag is not less than
\bold{less_than}.}
}
\value{
\code{\link{TRUE}} if the times do not differ `that much`, but see
\bold{stop_on_error}.
}
\description{
This is just a wrapper to \code{\link{difftime}}.
}
\examples{
a <- as.POSIXct(0, origin = "1970-01-01", tz = "GMT")
b <- as.POSIXct(60*60*24, origin = "1970-01-01", tz = "GMT")
c <- as.POSIXct(60*60*24 - 1, origin = "1970-01-01", tz = "GMT")
is_difftime_less(a, b)
is_difftime_less(a, c)
print(is_difftime_less(a, b, verbose = TRUE))
print(is_difftime_less(a, c, verbose = TRUE))
try(is_difftime_less(a, b, stop_on_error = TRUE))
is_difftime_less(a, c, verbose = TRUE, stop_on_error = TRUE)
}
\seealso{
Other bits and pieces: 
\code{\link{golden_ratio}()},
\code{\link{is_valid_primary_key}()},
\code{\link{r_cmd_install}()},
\code{\link{round_half_away_from_zero}()},
\code{\link{str2num}()},
\code{\link{strip_off_attributes}()},
\code{\link{tapply}()},
\code{\link{throw}()},
\code{\link{weighted_variance}()}
}
\concept{bits and pieces}
