% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_pills}
\alias{bs_vars_pills}
\title{Bootstrap pills variables}
\usage{
bs_vars_pills(
  border_radius = NULL,
  active_link_hover_bg = NULL,
  active_link_hover_color = NULL
)
}
\arguments{
\item{border_radius}{Rounded corner of elements.}

\item{active_link_hover_bg}{Background color when selected.}

\item{active_link_hover_color}{Text color when selected.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 pills (e.g. \code{\link[shiny:tabsetPanel]{shiny:tabsetPanel}}
 in Bootstrap and Bootswatch themes.
}
\examples{
bs_vars_pills(
  border_radius = "100px",
  active_link_hover_bg = "#DF3A01",
  active_link_hover_color = "#FFF"
)

if (interactive()) {
  library(shiny)
  library(fresh)

  ui <- fluidPage(
    use_theme(
      create_theme(
        theme = "default",
        bs_vars_pills(
          border_radius = "100px",
          active_link_hover_bg = "#DF3A01",
          active_link_hover_color = "#FFF"
        ),
        output_file = NULL
      )
    ),
    tabsetPanel(
      type = "pills",
      tabPanel("Plot", plotOutput("plot")),
      tabPanel("Summary", verbatimTextOutput("summary")),
      tabPanel("Table", tableOutput("table"))
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
