% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_alert}
\alias{bs_vars_alert}
\title{Bootstrap alert variables}
\usage{
bs_vars_alert(
  padding = NULL,
  border_radius = NULL,
  link_font_weight = NULL,
  success_text = NULL,
  success_bg = NULL,
  success_border = NULL,
  info_text = NULL,
  info_bg = NULL,
  info_border = NULL,
  warning_text = NULL,
  warning_bg = NULL,
  warning_border = NULL,
  danger_text = NULL,
  danger_bg = NULL,
  danger_border = NULL
)
}
\arguments{
\item{padding}{Padding for alerts.}

\item{border_radius}{Border radius (rounded corners)}

\item{link_font_weight}{Font weight for links in alerts.}

\item{success_text}{Success text color.}

\item{success_bg}{Success background color.}

\item{success_border}{Success border color.}

\item{info_text}{Info text color.}

\item{info_bg}{Info background color.}

\item{info_border}{Info border color.}

\item{warning_text}{Warning text color.}

\item{warning_bg}{Warning background color.}

\item{warning_border}{Warning border color.}

\item{danger_text}{Danger text color.}

\item{danger_bg}{Danger background color.}

\item{danger_border}{Danger border color.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 inputs in Bootstrap and Bootswatch themes.
}
\note{
See default parameters for Bootstrap: \url{https://getbootstrap.com/docs/3.4/customize/}.
}
\examples{
bs_vars_alert(
  border_radius = "10px", # increase border radius,
  success_bg = "#c9d175" # change color for success alerts
)

if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    use_theme(
      create_theme(
        theme = "default",
        bs_vars_alert(
          border_radius = "15px",
          success_bg = "forestgreen",
          success_text = "#FFF",
          danger_bg = "firebrick",
          danger_text = "#FFF"
        ),
        output_file = NULL
      )
    ),
    tags$br(),
    tags$div(
      class = "alert alert-success",
      "This is an alert !"
    ),
    tags$div(
      class = "alert alert-danger",
      "This is an other alert !"
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
