% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_modal}
\alias{bs_vars_modal}
\title{Bootstrap CSS modal variables}
\usage{
bs_vars_modal(md = NULL, lg = NULL, sm = NULL,
  inner_padding = NULL, title_padding = NULL,
  title_line_height = NULL, content_bg = NULL,
  content_border_color = NULL, content_fallback_border_color = NULL,
  backdrop_bg = NULL, backdrop_opacity = NULL,
  header_border_color = NULL, footer_border_color = NULL)
}
\arguments{
\item{md}{Size in pixel for medium modal, e.g. \code{modalDialog(size = "m")}.}

\item{lg}{Size in pixel for large modal, e.g. \code{modalDialog(size = "l")}.}

\item{sm}{Size in pixel for small modal, e.g. \code{modalDialog(size = "s")}.}

\item{inner_padding}{Padding applied to the modal body.}

\item{title_padding}{Padding applied to the modal title.}

\item{title_line_height}{Modal title line-height.}

\item{content_bg}{Background color of modal content area.}

\item{content_border_color}{Modal content border color.}

\item{content_fallback_border_color}{Modal content border color (for IE8).}

\item{backdrop_bg}{Modal backdrop background color.}

\item{backdrop_opacity}{Modal backdrop opacity.}

\item{header_border_color}{Modal header border color.}

\item{footer_border_color}{Modal footer border color.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 modal (e.g. \code{\link[shiny:modalDialog]{shiny::modalDialog}}
 in Bootstrap and Bootswatch themes.
}
\examples{
bs_vars_modal(
  md = "80\%",
  backdrop_opacity = 1,
  header_border_color = "#112446",
  footer_border_color = "#112446"
)

if (interactive()) {
  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(
    use_theme(
      create_theme(
        theme = "default",
        bs_vars_modal(
          md = "80\%",
          backdrop_opacity = 1,
          header_border_color = "#112446",
          footer_border_color = "#112446"
        ),
        output_file = NULL
      )
    ),
    tags$h1("Custom modals"),
    actionButton("show", "Show modal dialog")
  )

  server <- function(input, output, session) {

    observeEvent(input$show, {
      showModal(modalDialog(
        title = "Important message",
        "This is an important message!"
      ))
    })

  }

  shinyApp(ui, server)
}
}
