% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm10.R
\docType{data}
\name{pm10}
\alias{pm10}
\title{PM10 dataset}
\format{\eqn{175} daily distribution functions in the \code{fd} format
from the \pkg{fda} package}
\source{
Styrian Government, FA 17C Technical Environmental Protection and Safety, Air Quality Control Section,
}
\usage{
pm10
}
\description{
Concentration of partical matter of diameter 10 micrometers or smaller (\code{PM10})
is one of the most widely adopted measurements for assesment of ambient air quality.
In this dataset, we provide \eqn{175} measurement of daily temporal distribution of \code{PM10}
in Graz, Austria, collected between December 2004 and June 2005.

For the purpose of this R package, raw data of 48 observations per day, was transformed
to functional objects in Fourier basis using \pkg{fda} package.
}
\examples{
data(pm10)
summary(pm10)
plot(pm10)
}
\references{
Hormann, Siegfried, Brigitte Pfeiler, and Ernst Stadlober.
\emph{Analysis and prediction of particulate matter PM10 for the winter season in Graz.}
Austrian Journal of Statistics 34.4 (2005): 307-326.
}
\keyword{datasets}
