% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/french_data_list.R
\name{get_french_data_list}
\alias{get_french_data_list}
\title{Get list of files available on Kenneth's French data library website}
\usage{
get_french_data_list(max_tries = 3, refresh = FALSE)
}
\arguments{
\item{max_tries}{a number defining the maximum number of tries to perform when downloading the page.}

\item{refresh}{logical. If TRUE re-downloads the page and overwrites the cached information. Otherwise use the cached data if a download has been done in the current session.}
}
\value{
An object of class \code{\link[=french_data_list-class]{french_data_list}} with the following elements:
\itemize{
\item \code{info} - holds the information about when and were the information was retrieved.
\item \code{files_list} a tibble with with a list of files that can be downloaded, the tibble contains a \code{name}, \code{file_url} and \code{details_url} column.
}
}
\description{
Extract the list of files along with a description and links to them and additional information from the data library page of Prof. Kenneth French website.
}
\examples{
\donttest{
files_list <- get_french_data_list()
files_list
}

}
