% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cspline.R
\name{as_complex}
\alias{as_complex}
\title{Coerce two dimensional points to complex}
\usage{
as_complex(x, y = NULL)
}
\arguments{
\item{x, y}{A two dimensional specification, as allowed by grDevices::xy.coords}
}
\value{
A complex vector
}
\description{
Convenience function for allowing any of the usual ways two dimensional
points can be specified in traditional graphics to define a complex variable
}
\examples{
loc <- cbind(runif(20), runif(20))
z <- as_complex(loc)
z <- z-mean(z)
Mod(z) <- 1
z <- z[order(Arg(z))]
plot(closed_curve(z), asp = 1, col = 2)
lines(z, col = 4)
points(z, pch=16)
}
