% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti_to_mgh.R
\name{read.fs.volume.nii}
\alias{read.fs.volume.nii}
\title{Turn a 3D or 4D `oro.nifti` instance into an `fs.volume` instance with complete header.}
\usage{
read.fs.volume.nii(
  filepath,
  flatten = FALSE,
  with_header = FALSE,
  drop_empty_dims = FALSE,
  do_rotate = FALSE,
  ...
)
}
\arguments{
\item{filepath}{instance of class `nifti` from the `oro.nifti` package, or a path to a NIFTI file as a character string.}

\item{flatten}{logical. Whether to flatten the return volume to a 1D vector. Useful if you know that this file contains 1D morphometry data.}

\item{with_header}{logical. Whether to return the header as well. If TRUE, return an instance of class `fs.volume` for data with at least 3 dimensions, a named list with entries "data" and "header". The latter is another named list which contains the header data. These header entries exist: "dtype": int, one of: 0=MRI_UCHAR; 1=MRI_INT; 3=MRI_FLOAT; 4=MRI_SHORT. "voldim": integer vector. The volume (=data) dimensions. E.g., c(256, 256, 256, 1). These header entries may exist: "vox2ras_matrix" (exists if "ras_good_flag" is 1), "mr_params" (exists if "has_mr_params" is 1). See the `mghheader.*` functions, like \code{\link[freesurferformats]{mghheader.vox2ras.tkreg}}, to compute more information from the header fields.}

\item{drop_empty_dims}{logical, whether to drop empty dimensions of the returned data}

\item{do_rotate}{logical, whether to rotate 3D volumes to compensate for storage order. WIP.}

\item{...}{extra parameters passed to \code{oro.nifti::readNIfTI}. Leave this alone unless you know what you are doing.}
}
\value{
an `fs.volume` instance. The `header` fields are computed from the NIFTI header. The `data` array is rotated into FreeSurfer storage order, but otherwise returned as present in the input NIFTI instance, i.e., no values are changed in any way.
}
\description{
This is work in progress. This function takes an `oro.nifti` instance and computes the MGH header fields from the NIFTI header data, allowing for proper orientation of the contained image data (see \code{\link[freesurferformats]{mghheader.vox2ras}} and related functions). Currently only few datatypes are supported, and the `sform` header field needs to be present in the NIFTI instance.
}
\note{
This is not supposed to be used to read 1D morphometry data from NIFTI files generated by FreeSurfer (e.g., by converting `lh.thickness` to NIFTI using `mri_convert`): the FreeSurfer NIFTI hack is not supported by oro.nifti.
}
\examples{
\dontrun{
   base_file = "~/data/subject1_only/subject1/mri/brain";  # missing file ext.
   mgh_file = paste(base_file, '.mgz', sep='');  # the standard MGH/MGZ file
   nii_file = paste(base_file, '.nii', sep='');   # NIFTI file generated with mri_convert
   brain_mgh = read.fs.mgh(mgh_file, with_header = TRUE);
   brain_nii = read.fs.volume.nii(nii_file, with_header = TRUE);

   all(brain_nii$data == brain_mgh$data);                              # output: TRUE
   all(mghheader.vox2ras(brain_nii) == mghheader.vox2ras(brain_mgh))   # output: TRUE
}

}
\references{
See https://nifti.nimh.nih.gov/nifti-1/ for the NIfTI-1 data format spec.
}
\seealso{
\code{oro.nifti::readNIfTI}, \code{\link[freesurferformats]{read.fs.mgh}}
}
