% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mghheader.R
\name{surfaceras.to.ras}
\alias{surfaceras.to.ras}
\title{Translate surface RAS coordinates, as used in surface vertices and surface labels, to volume RAS.}
\usage{
surfaceras.to.ras(
  header_cras,
  sras_coords,
  first_voxel_RAS = c(1, 1, 1),
  invert_transform = FALSE
)
}
\arguments{
\item{header_cras}{an MGH header instance from which to extract the cras (center RAS), or the cras vector, i.e., a numerical vector of length 3}

\item{sras_coords}{nx3 numerical vector, the input surface RAS coordinates. Could be the vertex coordinates of an 'fs.surface' instance, or the RAS coords from a surface label. Use the orig surfaces.}

\item{first_voxel_RAS}{the RAS of the first voxel, see \code{\link{mghheader.centervoxelRAS.from.firstvoxelRAS}} for details. Ignored if 'header_cras' is a vector.}

\item{invert_transform}{logical, whether to invert the transform. Do not use this, call \code{link{ras.to.surfaceras}} instead.}
}
\value{
the RAS coords for the input sras_coords
}
\description{
Translate surface RAS coordinates, as used in surface vertices and surface labels, to volume RAS.
}
\note{
The RAS can be computed from Surface RAS by adding the center RAS coordinates, i.e., it is nothing but a translation.
}
