% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_mgh.R
\name{mgh.is.conformed}
\alias{mgh.is.conformed}
\title{Determine whether an MGH volume is conformed.}
\usage{
mgh.is.conformed(mgh_header, voxel_size_tolerance = 1e-04)
}
\arguments{
\item{mgh_header}{Header of the mgh datastructure, as returned by \code{\link[freesurferformats]{read.fs.mgh}}.}

\item{voxel_size_tolerance}{double, the tolerance to accept when comparing the voxel size to the required value of `1.0`. Defaults to `1e-4`. Leave this alone unless you know what you are doing.}
}
\value{
logical, whether the volume is *conformed*.
}
\description{
In the FreeSurfer sense, *conformed* means that the volume is in coronal primary slice direction, has dimensions 256x256x256 and a voxel size of 1 mm in all 3 directions. The slice direction can only be determined if the header contains RAS information, if it does not, the volume is not conformed.
}
\keyword{internal}
