% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate3d.R
\name{flip3D}
\alias{flip3D}
\title{Flip a 3D array along an axis.}
\usage{
flip3D(volume, axis = 1L, how = "horizontally")
}
\arguments{
\item{volume}{a 3D image volume}

\item{axis}{positive integer in range 1L..3L or an axis name, the axis to use.}

\item{how}{character string, one of 'horizontally' or 'vertically'. How to flip the 2D slices. Note that flipping *horizontally* means that the image will be mirrored along the central *vertical* axis.}
}
\value{
a 3D image volume, flipped around the axis. The dimensions are identical to the dimensions of the input image.
}
\description{
Flip the slice of an 3D array horizontally or vertically along an axis. This leads to an output array with identical dimensions.
}
\seealso{
Other volume math: 
\code{\link{rotate3D}()}
}
\concept{volume math}
