% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mris_convert_annot.R
\name{mris_convert_annot}
\alias{mris_convert_annot}
\title{Convert Annotation file}
\usage{
mris_convert_annot(annot, opts = "", ...)
}
\arguments{
\item{annot}{(character) annotation or gifti label data}

\item{opts}{(character) additional options to 
\code{\link{mris_convert}}}

\item{...}{additional arguments to \code{\link{mris_convert}}}
}
\value{
Result of \code{\link{mris_convert}}
}
\description{
This function call \code{mris_convert}, 
using the \code{--annot} option
}
\examples{
if (have_fs()) {
 bert_dir = file.path(fs_subj_dir(), "bert")
 gii_file = mris_convert_annot(
 infile = file.path(bert_dir, "surf", "lh.white"),
 annot = file.path(bert_dir, "label", "lh.aparc.annot"),
 ext = ".gii"
 )  
 gii = mris_convert_annot(
 infile = file.path(bert_dir, "surf", "lh.white"),
 annot = gii_file,
 ext = ".gii"
 )  
}   
}
