% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_label.R
\name{read_fs_label}
\alias{read_fs_label}
\title{Read Label File}
\usage{
read_fs_label(file)
}
\arguments{
\item{file}{label file from Freesurfer}
}
\value{
\code{data.frame} with 5 columns:
  \describe{
    \item{\code{vertex_num}:}{Vertex Number}
    \item{\code{r_coord}:}{Coordinate in RL direction}
    \item{\code{a_coord}:}{Coordinate in AP direction}
    \item{\code{s_coord}:}{Coordinate in SI direction}
    \item{\code{value}:}{ Value of label (depends on file)}
 }
}
\description{
Reads an \code{label} file from an individual subject
}
\examples{
if (have_fs()) {
 file = file.path(fs_subj_dir(), "bert", "label", "lh.BA1.label")
 out = read_fs_label(file)
}
}
