% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_series_search.R
\name{fredr_series_search_text}
\alias{fredr_series_search_text}
\alias{fredr_series_search_id}
\title{Search for a FRED series.}
\usage{
fredr_series_search_text(
  search_text,
  ...,
  tag_names = NULL,
  exclude_tag_names = NULL,
  filter_variable = NULL,
  filter_value = NULL,
  limit = NULL,
  offset = NULL,
  order_by = NULL,
  sort_order = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)

fredr_series_search_id(
  search_text,
  ...,
  limit = 1000L,
  offset = 0,
  order_by = NULL,
  sort_order = "asc",
  filter_variable = NULL,
  filter_value = NULL,
  realtime_start = NULL,
  realtime_end = NULL,
  tag_names = NULL,
  exclude_tag_names = NULL
)
}
\arguments{
\item{search_text}{A string containing the words to match against economic
data series. For use with \code{\link{fredr_series_search_text}} and
\code{\link{fredr_series_search_id}}.}

\item{...}{These dots only exist for future extensions and should be empty.}

\item{tag_names}{A semicolon delimited string of tag names that series match \emph{all} of.  Defaults to no tag filtering.}

\item{exclude_tag_names}{A semicolon delimited string of tag names that
series match \emph{none} of.  Defaults to no tag filtering.}

\item{filter_variable}{A string indicating the attribute to filter results
by. Possible values are: \code{"frequency"}, \code{"units"}, \code{"seasonal_adjustment"}.
Defaults to no filter.}

\item{filter_value}{The value of the \code{filter_variable} attribute to filter
by. Possible values depend on the value of \code{filter_variable}. Defaults to
no filter.}

\item{limit}{An integer limit on the maximum number of results to return.
Defaults to \code{1000}, the maximum.}

\item{offset}{An integer used in conjunction with \code{limit} for long series.
This mimics the idea of \emph{pagination} to retrieve large amounts of data over
multiple calls. Defaults to \code{0}.}

\item{order_by}{A string indicating the attribute to order results by.
Defaults to \code{"search_rank"} for \code{\link[=fredr_series_search_text]{fredr_series_search_text()}} and \code{"series_id"}
for \code{\link[=fredr_series_search_id]{fredr_series_search_id()}}. Possible values are:
\itemize{
\item \code{"search_rank"}
\item \code{"series_id"}
\item \code{"title"}
\item \code{"units"}
\item \code{"frequency"}
\item \code{"seasonal_adjustment"}
\item \code{"realtime_start"}
\item \code{"realtime_end"}
\item \code{"last_updated"}
\item \code{"observation_start"}
\item \code{"observation_end"}
\item \code{"popularity"}
\item \code{"group_popularity"}
}}

\item{sort_order}{A string representing the order of the resulting series.
Possible values are: \code{"asc"} (default), and \code{"desc"}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object where each row represents a series matching the query.
}
\description{
Search FRED for a series by full text of series or by series ID.
}
\examples{
if (fredr_has_key()) {
# search for series with text matching "oil" and return the top 10 most popular
# series
fredr_series_search_text(
  search_text = "oil",
  order_by = "popularity",
  limit = 10
)
# search for series with text matching "oil" with the tag "usa" and return the
# top 10 search results
fredr_series_search_text(
  search_text = "oil",
  order_by = "search_rank",
  limit = 10,
  tag_names = "usa"
)
# search for series with text matching "unemployment" and return only series
# with monthly frequency
fredr_series_search_text(
  search_text = "unemployment",
  filter_variable = "frequency",
  filter_value = "Monthly"
)
# search for series ID matching "UNRATE" and return oldest series first
fredr_series_search_id(
  search_text = "UNRATE",
  order_by = "observation_start"
)
}
}
\references{
API Documentation:

\href{https://fred.stlouisfed.org/docs/api/fred/series_search.html}{series/search}
}
\seealso{
\code{\link[=fredr_series_observations]{fredr_series_observations()}}, \code{\link[=fredr_series_search_tags]{fredr_series_search_tags()}},
\code{\link[=fredr_series_search_related_tags]{fredr_series_search_related_tags()}}, \code{\link[=fredr_series]{fredr_series()}}, \code{\link[=fredr_series_categories]{fredr_series_categories()}},
\code{\link[=fredr_series_release]{fredr_series_release()}}, \code{\link[=fredr_series_tags]{fredr_series_tags()}}, \code{\link[=fredr_series_updates]{fredr_series_updates()}},
\code{\link[=fredr_series_vintagedates]{fredr_series_vintagedates()}}.
}
