% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr-key.R
\name{fredr-key}
\alias{fredr-key}
\alias{fredr_set_key}
\alias{fredr_get_key}
\alias{fredr_has_key}
\title{FRED API key}
\usage{
fredr_set_key(key)

fredr_get_key()

fredr_has_key()
}
\arguments{
\item{key}{A valid FRED API key as a string. Obtain one at the \href{https://research.stlouisfed.org/docs/api/api_key.html}{API Keys} page. Can also be \code{NULL}
to unset the key for the current R session.}
}
\description{
Users of fredr must authenticate with the FRED API by use of an
API key. This key should be stored as an environment variable,
\code{FRED_API_KEY}.
\itemize{
\item \code{fredr_get_key()} will retrieve the key, if set, or it will return \code{NULL}
if the key is unset.
\item \code{fredr_set_key()} will set the key \emph{for the current R session}. For
persistence across sessions, set the environment variable.
See the Details section for more information.
\item \code{fredr_has_key()} returns \code{TRUE} if a key can be found. Otherwise it
returns \code{FALSE}.
}
}
\details{
The preferred method to set the key is to set the \code{FRED_API_KEY}
environment variable in an \code{.Renviron} file. The easiest way to do this is
by calling \code{usethis::edit_r_environ()}. Don't forget to restart R after
setting the key.
}
\examples{
original_key <- fredr_get_key()

# Set a once per session key
fredr_set_key("foo")

# Get it
fredr_get_key()

# Reset to original key
fredr_set_key(original_key)
}
\references{
See St. Louis Fed Web Services \href{https://research.stlouisfed.org/docs/api/api_key.html}{API Keys} to obtain an API key.
}
\seealso{
Note that by using a FRED API key, you agree to the FRED API \href{https://research.stlouisfed.org/docs/api/terms_of_use.html}{Terms of Use}.
}
