% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_series_release.R
\name{fredr_series_release}
\alias{fredr_series_release}
\title{Get the release for a FRED series}
\usage{
fredr_series_release(series_id = NULL, realtime_start = NULL,
  realtime_end = NULL)
}
\arguments{
\item{series_id}{A string ID for the FRED series. \emph{Required parameter.}}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object with information on the release for the series specified
by the \code{series_id} parameter.  Data include release ID, real-time periods, release name,
and links to press releases, if available.
}
\description{
Given a series ID, return information on a series as a \code{tibble} object.
}
\section{API Documentation}{


\href{https://research.stlouisfed.org/docs/api/fred/series_release.html}{fred/series/release}
}

\examples{
\donttest{
# Get release information for the "UNRATE" series
fredr_series_release(series_id = "UNRATE")
}
}
\seealso{
\code{\link[=fredr_series_observations]{fredr_series_observations()}}, \code{\link[=fredr_series_search_text]{fredr_series_search_text()}},
\code{\link[=fredr_series_search_id]{fredr_series_search_id()}}, \code{\link[=fredr_series_search_tags]{fredr_series_search_tags()}},
\code{\link[=fredr_series_search_related_tags]{fredr_series_search_related_tags()}}, \code{\link[=fredr_series]{fredr_series()}},
\code{\link[=fredr_series_categories]{fredr_series_categories()}}, \code{\link[=fredr_series_tags]{fredr_series_tags()}}, \code{\link[=fredr_series_updates]{fredr_series_updates()}},
\code{\link[=fredr_series_vintagedates]{fredr_series_vintagedates()}}.
}
