% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emfrail_arguments.R
\name{emfrail_dist}
\alias{emfrail_dist}
\title{Distribution parameters for emfrail}
\usage{
emfrail_dist(dist = "gamma", theta = 2, pvfm = -1/2,
  left_truncation = FALSE, basehaz = "breslow")
}
\arguments{
\item{dist}{One of 'gamma', 'stable' or 'pvf'.}

\item{theta}{A starting value for the 'outer' maximization with respect to the frailty parameter \eqn{\theta}. Must be >0.}

\item{pvfm}{Only relevant if \code{dist = 'pvf'} is used. It determines which PVF distribution should be used. Must be  larger than -1 and not equal to 0.}

\item{left_truncation}{Logical. Whether the data set represents left truncated survival times.}

\item{basehaz}{A character string which determines how the baseline hazard is calculated. The default is "breslow", but other possible options are "weibull", "exponential" "gaussian", "logistic", "lognormal" or "loglogistic".}
}
\value{
An object of the type \code{emfrail_dist}, which is mostly used to denote the
supported frailty distributions in a consistent way.
}
\description{
Distribution parameters for emfrail
}
\details{
The \code{theta} argument must be positive. In the case of gamma or PVF, this is the inverse of
 the frailty variance, i.e. the larger the \code{theta} is,
 the closer the model is to a Cox model. When \code{dist = "pvf"} and \code{pvfm = -0.5}, the inverse Gaussian
 distribution is obtained. For the positive stable distribution, the \eqn{\gamma} parameter of the Laplace transform is
 \eqn{\theta / (1 + \theta)}, with the \eqn{alpha} parameter fixed to 1.
}
\examples{
emfrail_dist()
# Compound Poisson distribution:
emfrail_dist(dist = 'pvf', theta = 1.5, pvfm = 0.5)
# Inverse Gaussian distribution:
emfrail_dist(dist = 'pvf')
}
\seealso{
\code{\link{emfrail}, \link{emfrail_control}}
}
