% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mra}
\alias{mra}
\title{Multiscale Regression Anlaysis (MRA)}
\usage{
mra(x, y, order, scales)
}
\arguments{
\item{x}{A real valued vector (i.e., time series data) to be analyzed. A key
difference between DCCA and MRA is that MRA produces asymmetric estiamtes. 
That is, x is assumed to be an independent variable and y is assumed to be 
a dependent variable. MRA should be used when one of the time series in 
question is usefully cast as the independent variable. That is, x is assumed
to effect change in y. If no such causal relationship is anticipated, use
DCCA instead.}

\item{y}{A real valued vector (i.e., time series data) to be analyzed.}

\item{order}{is an integer indicating the polynomial order used for 
detrending the local windows (e.g, 1 = linear, 2 = quadratic, etc.). There 
is not a pre-determined limit on the order of the polynomial order but the 
user should avoid using a large polynomial on small windows. This can result
in overfitting and non-meaningful estimates.}

\item{scales}{An integer vector of scales over which to compute correlation. 
Unlike univariate DFA, MRA does not require that scales be in log units.
Scale intervals can be sequential, for example, when the analysis is 
exploratory and no a priori hypotheses have been made about the scale of 
correlation. A small subset of targeted scales may also be investigated 
where scale-specific research questions exist. We have found that windows
smaller than say 8 observations create stability problems due to 
overfitting. This is espcially when the order of the fitting polynomial is 
large.}
}
\value{
The object returned from the mra() function is a list including the following:
\itemize{ 
 \item \code{scales} indicates the values of the scales used for estimates
 \item \code{betas} are the scale specific \eqn{\beta} estimates of the influence of x on y
 \item \code{r2} is the scale specific r-squared value of the model fit (i.e., variance in y accounted for by x at that scale)
 \item \code{t_observed} is the estimated t-statistic for a given \eqn{\beta} at a given scale. 
}
}
\description{
Fast function for computing multiscale regression analysis (MRA) on long time series. Combining DFA with ordinary least square regression, MRA
is a form of fractal regression that can be used to estimate asymmetric and multiscale regression coefficients between two variables.
}
\details{
Mathematical treatment of the MRA algorithm and its performance can be found in Kristoufek (2015) and Likens et al. (2019).

Note that under conditions with linear and quadratic trends, Likens et al. (2019) found that there was a systematic positive bias in the \eqn{\beta} estimates for larger scales.
Using a polynomial detrending order of 2 or greater was shown to attenuate this bias.
}
\examples{


# Here is a simple example for running MRA using a white noise and pink noise time series.
# For more detailed examples, see the vignette. 

noise <- rnorm(5000)

pink.noise <- fgn_sim(n = 5000, H = 0.9)

scales <- ifultools::logScale(scale.min = 10, scale.max = 1250, scale.ratio = 1.1)

mra.out <- mra(x = noise, y = pink.noise, order = 1, scales = scales)



}
\references{
Kristoufek, L. (2015). Detrended fluctuation analysis as a regression framework: Estimating dependence at different scales. Physical Review E, 91(2), 022802.

Likens, A. D., Amazeen, P. G., West, S. G., & Gibbons, C. T. (2019). Statistical properties of Multiscale Regression Analysis: Simulation and application to human postural control. Physica A: Statistical Mechanics and its Applications, 532, 121580.
}
