% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{aus_tobacco}
\alias{aus_tobacco}
\title{Australian cigarette and tobacco expenditure}
\format{
Time series of class `tsibble`
}
\source{
Australian Bureau of Statistics. \url{https://www.abs.gov.au/statistics/economy/national-accounts/australian-national-accounts-national-income-expenditure-and-product/mar-2024}
}
\description{
The total household expenditure for cigarette and tobacco consumption (CTC)
in Australia.
}
\details{
\code{aus_tobacco} contains quarterly data with one measured variable:
\tabular{ll}{
    \code{Expenditure}:  \tab The total expenditure\cr
}
from 1985 Q3 to 2023 Q4 for the 6 states and 2 territories of Australia,
indexed by:
\tabular{ll}{
    \code{Quarter}:  \tab Year-quarter.\cr
}

The prices are represented as a chain volume measure (a representation of constant prices) in billions of dollars.

Each series is uniquely identified using the key:
\tabular{ll}{
    \code{State}: The state or territory.\cr
}
}
\examples{

aus_tobacco |> autoplot(Expenditure) + scale_y_log10()

}
\keyword{datasets}
