% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formods.R
\name{FM_fetch_ds}
\alias{FM_fetch_ds}
\title{Fetches Datasets from Modules in the App}
\usage{
FM_fetch_ds(state, session, ids = NULL)
}
\arguments{
\item{state}{Current module state after yaml file has been read}

\item{session}{Shiny session variable}

\item{ids}{Vector of ID strings for the modules containing the datasets or
NULL for all datasets available.}
}
\value{
list containing the current dataset with the following format:
\itemize{
  \item{isgood:} Boolean indicating the whether a dataset was found
  (\code{FALSE})
  \item{ds:} List of datasets with element names corresponding to the
  R object name for that dataset. This has the following format
  \itemize{
    \item{label:}  Text label for the dataset (used to display to the user)
    \item{DS:}     Data frame with the dataset
    \item{DSMETA:} Data frame with metadata about the colunns of the
    dataset in \code{DS}. The data frame should have the following columns:
    \itemize{
       \item{col1:} column 1
    }
    \item{code:} Code to generate the dataset.
    \item{checksum:} Module checksum when the dataset was pulled
    \item{DSchecksum:} Checksum of the dataframe in DS
  }
  \item{catalog:} Dataframe containing the a tabular catalog of the
  datasets found.
  \itemize{
    \item{label:} Text label
    \item{object:} Name of the R Object containing the data frame
    \item{MOD_TYPE:} Short name of the type of module
    \item{id:} Module ID
    \item{idx:} Numerical identifyer within the module
    \item{checksum:} Module checksum
    \item{DSchecksum:} Checksum of the dataset
    \item{code:} Code to generate the dataset
  }
  \item{modules:} List with an entry for each module. The element name is
  the short name. Each of these is a list with an entry that is the shiny module
  ID. For each of these there is a checksum. For example to access the
  checksum of a DW module with a  module ID of 'my_id', you would use the
  following: \code{res$modules$DW$my_id}.
}
}
\description{
Loops through each specified module ID or all modules if no ID
was specified. For each ID, an attempt will be made to extract any datasets
available.
}
\examples{
# We need a module state and a Shiny session variable
# to use this function:
sess_res = UD_test_mksession()
session = sess_res$session
state   = sess_res$state
ds = FM_fetch_ds(state, session)
ds$catalog
}
