% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vol_summarise.R
\name{vol_summarise}
\alias{vol_summarise}
\title{Summarize volume of trees}
\usage{
vol_summarise(df, dbh, th, vwb, tree, .groups = NA, vwob = NA)
}
\arguments{
\item{df}{A data frame.}

\item{dbh}{Quoted name of the diameter at breast height variable, in cm.}

\item{th}{Quoted name of the total height variable, in meters.}

\item{vwb}{Quoted name of the volume with bark variable, in cubic meters.}

\item{tree}{Quoted name of the tree variable. used to differentiate the trees' sections. If this argument is \code{NA}, the defined groups in the data frame will be used. Default: \code{NA}.}

\item{.groups}{Optional argument. Quoted name(s) of additional grouping variables that can be added to differentiate subdivisions of the data.}

\item{vwob}{Optional argument. Quoted name of the volume without bark variable, in cubic meters. Default: \code{NA}.
If this argument is \code{NA}, the defined groups in the data frame will be used. Default: \code{NA}.}
}
\value{
A data frame summarized by the .groups variable(s).
}
\description{
This function can be used to summarize volume with and without bark
of trees in a data frame.
}
\examples{
library(forestmangr)
data("exfm7")
exfm7

# In order to calculate the volume of each tree, first we
# Calculate the volume by tree section using the Smalian method:
sec_data_vol <- exfm7 \%>\% 
smalianwb("di_wb", "hi", "TREE") \%>\% 
smalianwob("di_wb", "hi", "bark_t", "TREE", bt_mm_to_cm = TRUE)

sec_data_vol

# Now, we summarize the tree's volume:
vol_summarise(sec_data_vol, dbh = "DBH", th = "TH", vwb = "VWB",
tree = "TREE", .groups = "STRATA",vwob = "VWOB")

# It's possible to do everything using pipes:
exfm7 \%>\% 
smalianwb("di_wb", "hi", "TREE") \%>\% 
smalianwob("di_wb", "hi", "bark_t", "TREE", bt_mm_to_cm = TRUE) \%>\% 
vol_summarise("DBH", "TH", "VWB", "TREE", "STRATA", "VWOB")

}
\seealso{
Complementary functions:
  \code{\link{smalianwb}}, For calculation of volume with bark using the Smalian method,
  \code{\link{smalianwob}}, For calculation of volume without bark using the Smalian method,
  \code{\link{huberwb}}, for calculation of volume with bark using the Huber method,
  \code{\link{huberwob}}, for calculation of volume without bark the Huber method.
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
