# Copyright (c) 2023 Merck & Co., Inc., Rahway, NJ, USA and its affiliates.
# All rights reserved.
#
# This file is part of the forestly program.
#
# forestly is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#' An adverse event dataset
#'
#' A dataset containing the adverse event information of a clinical trial
#' following the CDISC ADaM standard.
#'
#' Definition of each variable can be found at
#' <https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc>.
#'
#' @format A data frame with 736 rows and 56 variables.
#'
#' @source <https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc>
"forestly_adae"

#' A subject level demographic dataset
#'
#' A dataset containing the demographic information of a clinical trial
#' following the CDISC ADaM standard.
#'
#' Definition of each variable can be found at
#' <https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc>.
#'
#' @format A data frame with 170 rows and 49 variables.
#'
#' @source <https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc>
"forestly_adsl"

#' An adverse event dataset
#'
#' A dataset containing the adverse event information of a clinical trial
#' following the CDISC ADaM standard.
#'
#' Definition of each variable can be found at
#' <https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc>.
#'
#' @format A data frame with 1191 rows and 56 variables.
#'
#' @source <https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc>
"forestly_adae_3grp"

#' A subject level demographic dataset
#'
#' A dataset containing the demographic information of a clinical trial
#' following the CDISC ADaM standard.
#'
#' Definition of each variable can be found at
#' <https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc>.
#'
#' @format A data frame with 254 rows and 49 variables.
#'
#' @source <https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc>
"forestly_adsl_3grp"
