% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{predict.comp_bayes_lm}
\alias{predict.comp_bayes_lm}
\title{Make predictions based on fitted Bayesian model}
\source{
Closed-form solutions of Bayesian linear
regression \doi{10.1371/journal.pone.0229930.s004}
}
\usage{
\method{predict}{comp_bayes_lm}(object, newdata, ...)
}
\arguments{
\item{object}{Output of \code{\link[=comp_bayes_lm]{comp_bayes_lm()}}: A list of
\verb{\{a_star, b_star, mu_star, V_star\}} posterior hyperparameters}

\item{newdata}{A data frame of type \code{focal_vs_comp} in which to look for variables with which to predict.}

\item{...}{Currently ignored—only included for consistency with generic.}
}
\value{
A vector of predictions with length equal to the input data.
}
\description{
Applies fitted model from \code{\link[=comp_bayes_lm]{comp_bayes_lm()}} and
returns posterior predicted values.
}
\examples{
library(dplyr)
library(sf)
library(ggplot2)

# Load in posterior parameter example
# and growth data to compare to
data(comp_bayes_lm_ex, growth_ex)

predictions <- focal_vs_comp_ex \%>\%
  mutate(growth_hat = predict(comp_bayes_lm_ex, focal_vs_comp_ex))

predictions \%>\%
  ggplot(aes(growth, growth_hat)) +
  geom_point() +
  geom_abline(slope = 1, intercept = 0)
}
\seealso{
Other modeling functions: 
\code{\link{comp_bayes_lm}()},
\code{\link{create_bayes_lm_data}()},
\code{\link{run_cv}()}
}
\concept{modeling functions}
