% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.forestData}
\alias{summary.forestData}
\title{Summary of forestData}
\usage{
\method{summary}{forestData}(object, ...)
}
\arguments{
\item{object}{A forestData object (after class.plot).}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
A summary object of class "summary.forestData"
}
\description{
Generates summary statistics for forestData objects.
}
\details{
The summary includes the summary of raw data, the model, the model parameters, potential productivity and real productivity in forestData(if available)
}
\examples{
\donttest{
# Load the forestat.csv sample data
forestData <- read.csv(system.file("extdata", "forestData.csv", package = "forestat"))

# Build a model based on the forestData and return a forestData class object
forestData <- class.plot(forestData,model="Richards",
                         interval=5,number=5,
                         a=19,b=0.1,c=0.8)

# Get the summary data of the forestData object
summary(forestData)
}
}
