% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_model.R
\name{plot.forecast_results}
\alias{plot.forecast_results}
\title{Plot an object of class forecast_results}
\usage{
\method{plot}{forecast_results}(x, data_actual = NULL,
  actual_indices = NULL, models = NULL, horizons = NULL,
  windows = NULL, facet_plot = c("model", "model_forecast_horizon"),
  group_filter = NULL, ...)
}
\arguments{
\item{x}{An object of class 'forecast_results' from \code{predict.forecast_model()}.}

\item{data_actual}{A data.frame containing the target/outcome name and any grouping columns.
The data can be historical actuals and/or holdout/test data.}

\item{actual_indices}{Required if \code{data_actual} is given. A vector or 1-column data.frame
of numeric row indices or dates (class 'Date' or 'POSIXt') with length \code{nrow(data_actual)}.
The data can be historical actuals and/or holdout/test data.}

\item{models}{Optional. Filter results by user-defined model name from \code{train_model()}.}

\item{horizons}{Optional. Filter results by horizon.}

\item{windows}{Optional. Filter results by validation window number.}

\item{facet_plot}{Adjust the plot display through \code{ggplot2::facet_grid()}.
\code{facet_plot = NULL} plots results in one facet.}

\item{group_filter}{Optional. A string for filtering plot results for grouped time-series (e.g., \code{"group_col_1 == 'A'"});
passed to \code{dplyr::filter()} internally.}

\item{...}{Not used.}
}
\value{
Forecast plot of class 'ggplot'.
}
\description{
A forecast plot for each horizon for each model in \code{predict.forecast_model()}.
}
