\name{forecast.stl}
\alias{forecast.stl}
\alias{stlf}
\alias{stl}
\alias{stlm}
\alias{forecast.stlm}
\title{Forecasting using stl objects}
\usage{
stlm(x, s.window=7, robust=FALSE, method=c("ets","arima"), 
     modelfunction=NULL, etsmodel="ZZN", lambda=NULL, xreg=NULL, 
     allow.multiplicative.trend=FALSE, ...)
stlf(x, h=frequency(x)*2, s.window=7, t.window=NULL, robust=FALSE, lambda=NULL, ...)
\method{forecast}{stlm}(object, h = 2*object$m, 
	level = c(80, 95), fan = FALSE, lambda=object$lambda, newxreg=NULL,
  allow.multiplicative.trend=FALSE, ...)
\method{forecast}{stl}(object, method=c("ets","arima","naive","rwdrift"), 
    etsmodel="ZZN", forecastfunction=NULL,
    h=frequency(object$time.series)*2, level=c(80,95), 
    fan=FALSE, lambda=NULL, xreg=NULL, newxreg=NULL, 
    allow.multiplicative.trend=FALSE, ...)
}

\arguments{
\item{x}{A univariate numeric time series of class \code{ts}}
\item{object}{An object of class \code{stl} or \code{stlm}. Usually the result of a call to \code{\link[stats]{stl}} or \code{stlm}.}
\item{method}{Method to use for forecasting the seasonally adjusted series.}
\item{modelfunction}{An alternative way of specifying the function for modelling the seasonally adjusted series. If \code{modelfunction} is not \code{NULL}, then \code{method} is
ignored. Otherwise \code{method} is used to specify the time series model to be used.}
\item{forecastfunction}{An alternative way of specifying the function for forecasting the seasonally adjusted series. If \code{forecastfunction} is not \code{NULL}, then \code{method} is
ignored. Otherwise \code{method} is used to specify the forecasting method to be used.}
\item{etsmodel}{The ets model specification passed to \code{\link[forecast]{ets}}. By default it allows any non-seasonal model. If \code{method!="ets"}, this argument is ignored.}
\item{xreg}{Historical regressors to be used in \code{\link[forecast]{auto.arima}()} when 
\code{method=="arima"}.}
\item{newxreg}{Future regressors to be used in \code{\link[forecast]{forecast.Arima}()}.}
\item{h}{Number of periods for forecasting.}
\item{level}{Confidence level for prediction intervals.}
\item{fan}{If \code{TRUE}, level is set to seq(51,99,by=3). This is suitable for fan plots.}
\item{lambda}{Box-Cox transformation parameter. Ignored if \code{NULL}. Otherwise, data transformed before decomposition and back-transformed after forecasts are computed.}
\item{s.window}{Either the character string ``periodic'' or the span (in lags) of the loess window for seasonal extraction.}
\item{t.window}{A number to control the smoothness of the trend. See \code{\link[stats]{stl}} for details.}
\item{robust}{If \code{TRUE}, robust fitting will used in the loess procedure within \code{\link[stats]{stl}}.}
\item{allow.multiplicative.trend}{If TRUE, then ETS models with multiplicative trends are allowed. Otherwise, only additive or no trend ETS models are permitted.}
\item{...}{Other arguments passed to \code{forecast.stl}, \code{modelfunction} or \code{forecastfunction}.}
}

\description{Forecasts of STL objects are obtained by applying a non-seasonal forecasting method
to the seasonally adjusted data and re-seasonalizing using the last year of the seasonal component.
}

\details{\code{stlm} takes a time series \code{x}, applies an STL decomposition, and models the seasonally adjusted data using the model passed as \code{modelfunction} or specified using \code{method}. It returns an object that includes the original STL decomposition and a time series model fitted to the seasonally adjusted data. This object can be passed to the \code{forecast.stlm} for forecasting.

\code{forecast.stlm} forecasts the seasonally adjusted data, then re-seasonalizes the results by adding back the last year of the estimated seasonal component.

\code{stlf} combines \code{stlm} and \code{forecast.stlm}. It takes a \code{ts} argument, applies an STL decomposition, models the seasonally adjusted data, reseasonalizes, and returns the forecasts. However, it allows more general forecasting methods to be specified via \code{forecastfunction}.

\code{forecast.stl} is similar to \code{stlf} except that it takes the STL decomposition as the first argument, instead of the time series. 

Note that the prediction intervals ignore the uncertainty associated with the seasonal component. THey are computed using the prediction intervals from the seasonally adjusted series, which are then reseasonalized using the last year of the seasonal component. The uncertainty in the seasonal component is ignored.

The time series model for the seasonally adjusted data can be specified in \code{stlm} using either \code{method} or \code{modelfunction}. The \code{method} argument provides a shorthand way of specifying \code{modelfunction} for a few special cases. More generally, \code{modelfunction} can be any function with first argument a \code{ts} object, that returns an object that can be passed to \code{\link{forecast}}. For example, \code{forecastfunction=ar} uses the \code{\link{ar}} function for modelling the seasonally adjusted series.

The forecasting method for the seasonally adjusted data can be specified in \code{stlf} and \code{forecast.stl} using either \code{method} or \code{forecastfunction}. The \code{method} argument provides a shorthand way of specifying \code{forecastfunction} for a few special cases. More generally, \code{forecastfunction} can be any function 
with first argument a \code{ts} object, and other \code{h} and \code{level}, which returns an object of class \code{\link{forecast}}. For example, \code{forecastfunction=thetaf} uses the \code{\link{thetaf}} function for forecasting the seasonally adjusted series.
}


\value{\code{stlm} returns an object of class \code{stlm}. The other functions return objects of class \code{forecast}.

There are many methods for working with \code{\link{forecast}} objects including  \code{summary}  to obtain and print a summary of the
results, while \code{plot} produces a plot of the forecasts and prediction intervals.
The generic accessor functions \code{fitted.values} and \code{residuals} extract useful features.

}

\seealso{\code{\link[stats]{stl}}, \code{\link{forecast.ets}}, \code{\link{forecast.Arima}}.}

\author{Rob J Hyndman}

\examples{
tsmod <- stlm(USAccDeaths, modelfunction=ar)
plot(forecast(tsmod, h=36))

plot(stlf(AirPassengers, lambda=0))

decomp <- stl(USAccDeaths,s.window="periodic")
plot(forecast(decomp))


}
\keyword{ts}
