\name{nnetar}
\alias{nnetar}
\alias{forecast.nnetar}

\title{Neural Network Time Series Forecasts}
\usage{nnetar(x, p, P=1, size, repeats=20, lambda=NULL)
\method{forecast}{nnetar}(object, h=ifelse(object$m > 1, 2 * object$m, 10), 
    lambda=object$lambda, ...)
}

\arguments{
\item{x}{a numeric vector or time series}
\item{p}{Embedding dimension for non-seasonal time series. Number of non-seasonal lags used as inputs. For non-seasonal time series, the default is the optimal number of lags (according to the AIC) for a linear AR(p) model. For seasonal time series, the same method is used but applied to seasonally adjusted data (from an stl decomposition).}
\item{P}{Number of seasonal lags used as inputs.}
\item{size}{Number of nodes in the hidden layer. Default is half of the number of input nodes plus 1.}
\item{repeats}{Number of networks to fit with different random starting weights. These are then averaged when producing forecasts.}
\item{lambda}{Box-Cox transformation parameter.}
\item{object}{An object of class \code{nnetar} generated by \code{\link{nnetar}}.}
\item{h}{Number of periods for forecasting.}
\item{...}{Other arguments.}
}

\description{Feed-forward neural networks with a single hidden layer and lagged inputs for forecasting univariate time series.}

\details{A feed-forward neural network is fitted with lagged values of \code{x} as inputs and a single hidden layer with \code{size} nodes. The inputs are for lags 1 to \code{p}, and lags \code{m} to \code{mP} where \code{m=frequency(x)}. A total of \code{repeats} networks are fitted, each with random starting weights. These are then averaged when computing forecasts. The network is trained for one-step forecasting. Multi-step forecasts are computed recursively. The fitted model is called an NNAR(p,P) model and is analogous to an ARIMA(p,0,0)(P,0,0) model but with nonlinear functions.
}


\value{\code{nnetar} returns an object of class "\code{nnetar}". \code{forecast.nnetar} 
returns an object of class "\code{forecast}".

The function \code{summary} is used to obtain and print a summary of the
results, while the function \code{plot} produces a plot of the forecasts.

The generic accessor functions \code{fitted.values} and \code{residuals} extract useful features of the value returned by \code{nnetar}.

An object of class \code{"forecast"} is a list containing at least the following elements:
\item{model}{A list containing information about the fitted model}
\item{method}{The name of the forecasting method as a character string}
\item{mean}{Point forecasts as a time series}
\item{x}{The original time series (either \code{object} itself or the time series used to create the model stored as \code{object}).}
\item{residuals}{Residuals from the fitted model. That is x minus fitted values.}
\item{fitted}{Fitted values (one-step forecasts)}
\item{...}{Other arguments}
}


\author{Rob J Hyndman}

\examples{fit <- nnetar(lynx)
fcast <- forecast(fit)
plot(fcast)
}

\keyword{ts}
