% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simCity.R
\name{modSimulator}
\alias{modSimulator}
\title{modSimulator}
\usage{
modSimulator(
  datStart = NULL,
  datFinish = NULL,
  modelTag = NULL,
  parS = NULL,
  seed = NULL,
  file = NULL,
  IOmode = "suppress"
)
}
\arguments{
\item{datStart}{A date string in an accepted date format e.g.
\emph{"01-10-1990"}.}

\item{datFinish}{A date string in an accepted date format e.g.
\emph{"01-10-1990"}. Must occur after datStart.}

\item{modelTag}{A character vector of which stochastic models to use to
create each climate variable. Supported tags are shown in details below.}

\item{parS}{A list (names must match supplied modelTags) containing numeric
vectors of model parameters.}

\item{seed}{Numeric. Seed value supplied to weather generator.}

\item{file}{Character. Specifies filename for simulation output.}

\item{IOmode}{A string that specifies the input-output mode for the time
series = "verbose", "dev" or "suppress".}
}
\description{
Simulates using weather generator models specified using modelTag.
}
\details{
modelTag provides the main function with requested models. modelTag is
vector of any of the following supported models:
\itemize{
\item \code{"P-ann-wgen"} a four parameter annual rainfall model
\item \code{"P-seas-wgen"} a 16 parameter seasonal rainfall model
(phase angles must be specified via modelInfoMod=list("P-har12-wgen-FS"=fixedPars=c(x,x,x,x))
\item \code{"P-har-wgen"} a harmonic rainfall model
\item \code{"Temp-har-wgen"} a harmonic temperature model not conditional on rainfall
\item \code{"Temp-har-wgen-wd"} a harmonic temperature model dependent on wet or
dry day
\item \code{"Temp-har-wgen-wdsd"} a harmonic temperature model
where standard deviation parameters are dependent on wet or dry day
\item \code{"PET-har-wgen"}a harmonic potential evapotranspiration model
\item \code{"PET-har-wgen-wd"} a harmonic potential evapotranspiration model
dependent on wet or dry day
\item \code{"Radn-har-wgen"} a harmonic solar radiation model (MJ/m2) }
}
\examples{

\dontrun{
data(tankDat); obs=tank_obs                     #Get observed data
modelTag=c("P-har-wgen","Temp-har-wgen")    #Select models
pars=modCalibrator(obs=obs,modelTag=modelTag)   #Calibrate models
sim=modSimulator(datStart="1970-01-01",         #Simulate!
                 datFinish="1999-12-31",
                 modelTag=modelTag,
                 parS=pars,
                 seed=123,
                 file=paste0("tester.csv"),
                 IOmode="verbose")
plot(sim$P[1:365])                             #Plot first year of rainfall
}
}
