% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_ts.r
\name{geom_ts}
\alias{geom_ts}
\title{Plot time series}
\usage{
geom_ts(
  df,
  yl = NULL,
  yr = NULL,
  yllab = NULL,
  yrlab = NULL,
  xlab = NULL,
  llist = NULL,
  plist = NULL,
  alist = NULL,
  blist = NULL,
  llab = NULL,
  plab = NULL,
  alab = NULL,
  blab = NULL,
  ltype = NULL,
  pshape = NULL,
  lsize = 1,
  psize = 1,
  lcc = NULL,
  pcc = NULL,
  aff = NULL,
  bff = NULL,
  ana = TRUE,
  apos = "stack",
  bna = TRUE,
  bpos = "identity"
)
}
\arguments{
\item{df}{dataframe contains time series.}

\item{yl}{vector, col index of species to be putted in the left y axis.}

\item{yr}{vector, col index of species to be putted in the right y axis. The default vaule is NULL.}

\item{yllab}{text expression of left y axis label. The default vaule is NULL.}

\item{yrlab}{text expression of right y axis label. The default vaule is NULL.}

\item{xlab}{text expression of x axis label. The default vaule is NULL.}

\item{llist}{vector, col index of species to be ploted by line.The default vaule is NULL.}

\item{plist}{vector, col index of species to be ploted by points.The default vaule is NULL.}

\item{alist}{plist vector, col index of species to be ploted by areas. The default vaule is NULL.}

\item{blist}{plist vector, col index of species to be ploted by bars. The default vaule is NULL.}

\item{llab}{text expression of legend labels of lines. The default vaule is NULL.}

\item{plab}{text expression of legend labels of points. The default vaule is NULL.}

\item{alab}{text expression of legend labels of areas. The default vaule is NULL.}

\item{blab}{text expression of legend labels of bars. The default vaule is NULL.}

\item{ltype}{vector, type of lines. The default vaule is NULL.}

\item{pshape}{vector, shape of points. The default vaule is NULL.}

\item{lsize}{vector, size of lines. The default vaule is NULL.The default vaule is 1.}

\item{psize}{vector, size of points. The default vaule is NULL.The default vaule is 1.}

\item{lcc}{vector, colors of lines. The default vaule is NULL. The default vaule is NULL.}

\item{pcc}{vector, colors of points. The default vaule is NULL. The default vaule is NULL.}

\item{aff}{fill color of areas. The default vaule is NULL.}

\item{bff}{fill color of bars. The default vaule is NULL.}

\item{ana}{logical value, the way to handle NA values for areas. If you select FALSE, NA value will be replaced by 0.}

\item{apos}{Position adjustment for areas, either as a string, or the result of a call to a position adjustment function.}

\item{bna}{logical value, the way to handle NA values for bars. If you select FALSE, NA value will be replaced by 0.}

\item{bpos}{Position adjustment for bars, either as a string, or the result of a call to a position adjustment function.}
}
\description{
Easy way to plot time series.
}
\examples{
\dontrun{ 
aqi2=aqi
aqi2$NO[aqi2$NO>7]=NA
aqi2$NO2=aqi2$NO2*0.3
geom_ts(
    	df=aqi2,
    	yl=c(3,2), 
    	yr=6, 
    	alist=c(3,2), 
    	llist=6, 
   	alab=list(bquote(NO[2]~" "), bquote(NO~" ")),
		llab=list(bquote(O[3]~" ")),
     yllab=bquote(NO[x]~" "~(ppbv)),
     yrlab=bquote(O[3]~" "~(ppbv)),
     lcc="#ff4d4f", 
     aff=c("#096dd9","#69c0ff"),
xlab="Datetime")
}
}
