% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_foot.R
\name{compare_foot}
\alias{compare_foot}
\title{Compare Football Models using Various Metrics}
\usage{
compare_foot(
  source,
  test_data,
  metric = c("accuracy", "brier", "ACP", "pseudoR2", "RPS"),
  conf_matrix = FALSE
)
}
\arguments{
\item{source}{A named list containing either:
\itemize{
  \item Fitted model objects (of class \code{stanFoot} or \code{stanfit}), each representing a football model.
  \item Matrices where each matrix contains the estimated probabilities for "Home Win," "Draw," and "Away Win" in its columns.
}}

\item{test_data}{A data frame containing the test dataset, with columns:
\itemize{
  \item \code{home_team}: Home team's name (character string).
  \item \code{away_team}: Away team's name (character string).
  \item \code{home_goals}: Goals scored by the home team (integer >= 0).
  \item \code{away_goals}: Goals scored by the away team (integer >= 0).
}}

\item{metric}{A character vector specifying the metrics to use for comparison. Options are:
\itemize{
  \item \code{"accuracy"}: Computes the accuracy of each model.
  \item \code{"brier"}: Computes the Brier score of each model.
  \item \code{"RPS"}: Computes the ranked probability score (RPS) for each model.
  \item \code{"ACP"}: Computes the average coverage probability (ACP) for each model.
  \item \code{"pseudoR2"}: Computes the Pseudo \eqn{R^2}, defined as the geometric mean of the probabilities assigned to the actual results.
}
Default is \code{c("accuracy", "brier", "ACP", "pseudoR2", "RPS")}, computing the specified metrics.}

\item{conf_matrix}{A logical value indicating whether to generate a confusion matrix comparing predicted outcomes against actual outcomes for each model or probability matrix. Default is \code{FALSE}.}
}
\value{
An object of class \code{compare_foot_output}, which is a list containing:
  \itemize{
    \item \code{metrics}: A data frame containing the metric values for each model or probability matrix.
    \item \code{confusion_matrix}: Confusion matrices for each model or probability matrix.
  }
}
\description{
Compares multiple football models or directly provided probability matrices based on specified metrics (accuracy, Brier score, ranked probability score, Pseudo \eqn{R^2}, average coverage probability), using a test dataset. Additionally, computes the confusion matrices. The function returns an object of class \code{compareFoot}.
}
\details{
The function extracts predictions from each model or directly uses the provided probability matrices and computes the chosen metrics on the test dataset. It also possible to compute confusion matrices.
}
\examples{
\dontrun{
library(dplyr)

data("italy")
italy_2000 <- italy \%>\%
  dplyr::select(Season, home, visitor, hgoal, vgoal) \%>\%
  dplyr::filter(Season == "2000")

colnames(italy_2000) <- c("periods", "home_team", "away_team", "home_goals", "away_goals")

# Example with fitted models
fit_1 <- stan_foot(data = italy_2000,
                   model = "double_pois", predict = 18)  # Double Poisson model
fit_2 <- stan_foot(data = italy_2000,
                   model = "biv_pois", predict = 18)     # Bivariate Poisson model

italy_2000_test <- italy_2000[289:306, ]


compare_results_models <- compare_foot(
  source = list(double_poisson = fit_1,
                bivariate_poisson = fit_2),
  test_data = italy_2000_test,
  metric = c("accuracy", "brier", "ACP", "pseudoR2", "RPS"),
  conf_matrix = TRUE
)

print(compare_results_models)
}
}
\author{
Roberto Macrì Demartino \email{roberto.macridemartino@phd.unipd.it}
}
