% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fG_mpm.R
\name{plot.fG_mpm}
\alias{plot.fG_mpm}
\title{plot}
\usage{
\method{plot}{fG_mpm}(
  x,
  y = NULL,
  se = FALSE,
  pages = 0,
  ncol = 1,
  ask = TRUE,
  pal = "Zissou1",
  rev = FALSE,
  ...
)
}
\arguments{
\item{x}{a \code{foieGras} \code{mpm} fit object with class \code{fG_mpm}}

\item{y}{optional \code{ssm} fit object with class \code{fG_ssm} corresponding to x. If absent, 1-d plots of \code{gamma_t} time series are rendered
otherwise, 2-d track plots with locations coloured by \code{gamma_t} are rendered.}

\item{se}{logical (default = FALSE); should points be scaled by \code{gamma_t} uncertainty (ignored if y is not supplied)}

\item{pages}{plots of all individuals on a single page (pages = 1; default) or each individual on a separate page (pages = 0)}

\item{ncol}{number of columns to use for faceting. Default is ncol = 1 but this may be increased for multi-individual objects. Ignored if pages = 0}

\item{ask}{logical; if TRUE (default) user is asked for input before each plot is rendered. set to FALSE to return ggplot objects}

\item{pal}{\code{hcl.colors} palette to use (default: "Zissou1"; type \code{hcl.pals()} for options)}

\item{rev}{reverse colour palette (logical)}

\item{...}{additional arguments to be ignored}
}
\value{
a ggplot object with either: 1-d time series of \code{gamma_t} estimates (if y not provided), with estimation uncertainty ribbons (95 \% CI's);
or 2-d track plots (if y provided) coloured by \code{gamma_t}, with smaller points having greater uncertainty (size is proportional to \code{SE^-2}, if se = TRUE).
Plots can be rendered all on a single page (pages = 1) or on separate pages.
}
\description{
visualize fits from an fG_mpm object
}
\examples{
# plot mpm fit object
# 1-d time-series plots
plot(xm) 
# 2-d track plots by adding ssm fit object
plot(xm, xs) 

}
