% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_ssm.R
\name{fit_ssm}
\alias{fit_ssm}
\title{Fit a continuous-time state-space model to filter Argos satellite geolocation data}
\usage{
fit_ssm(d, vmax = 50, ang = -1, distlim = c(2500, 5000),
  spdf = TRUE, min.dt = 60, pf = FALSE, model = "rw",
  time.step = 6, parameters = NULL, fit.to.subset = TRUE,
  optim = "nlminb", verbose = 1, inner.control = NULL)
}
\arguments{
\item{d}{a data frame of observations including Argos KF error ellipse info}

\item{vmax}{max travel rate (m/s) passed to argosfilter::sdafilter to define
outlier locations}

\item{ang}{angles of outlier location "spikes" - see ?argosfilter::sdafilter
for details}

\item{distlim}{lengths of outlier location "spikes" - see
?argosfilter::sdafilter for details}

\item{spdf}{(logical) turn argosfilter::sdafilter on (default; TRUE) or off}

\item{min.dt}{minimum allowable time difference between observations;
dt <= min.dt will be ignored by the SSM}

\item{pf}{just pre-filter the data, do not fit the ctrw (default is FALSE)}

\item{model}{fit either a simple random walk ("rw") or correlated random walk
("crw") as a continuous-time process model}

\item{time.step}{the regular time interval, in hours, to predict to.
Alternatively, a vector of prediction times, possibly not regular, must be
specified as a data.frame with id and POSIXt dates.}

\item{parameters}{a list of initial values for all model parameters and
unobserved states, default is to let sfilter specifiy these. Only play with
this if you know what you are doing...}

\item{fit.to.subset}{fit the SSM to the data subset determined by prefilter
(default is TRUE)}

\item{optim}{numerical optimizer to be used ("nlminb" or "optim")}

\item{verbose}{report progress during minimization; 0 for complete silence; 1 for progress bar only; 2 for minimizer trace but not progress bar}

\item{inner.control}{list of control settings for the inner optimization
(see ?TMB::MakeADFUN for additional details)}
}
\value{
a list with components
\item{\code{call}}{the matched call}
\item{\code{predicted}}{an sf tbl of predicted location states}
\item{\code{fitted}}{an sf tbl of fitted locations}
\item{\code{par}}{model parameter summmary}
\item{\code{data}}{an augmented sf tbl of the input data}
\item{\code{inits}}{a list of initial values}
\item{\code{pm}}{the process model fit, either "rw" or "crw"}
\item{\code{ts}}{time time.step in h used}
\item{\code{opt}}{the object returned by the optimizer}
\item{\code{tmb}}{the TMB object}
\item{\code{rep}}{TMB sdreport}
\item{\code{aic}}{the calculated Akaike Information Criterion}
\item{\code{time}}{the processing time for sfilter}
}
\description{
fits either a simple random walk or a correlated random walk
(a random walk on velocity) in continuous time to filter Argos KF and/or LS data
and predict locations at user-specified time intervals (regular or irregular)
}
\examples{
## fit crw model to multiple individuals with Argos LS data
data(ellie)
fit <- fit_ssm(ellie, model = "rw", time.step = 24)
plot(fit$ssm[[1]])

\donttest{
data(rope)
fls <- fit_ssm(rope, model = "crw", time.step = 12)

## simple diagnostic plot for individual 3,
## showing predicted value time-series
plot(fls$ssm[[3]], what = "predicted")
}

}
