% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcat.R
\name{fcat}
\alias{fcat}
\title{Create a format catalog}
\usage{
fcat(..., log = TRUE)
}
\arguments{
\item{...}{A set of formats. Pass the formats as a name/value pair.  Multiple
name/value pairs are separated by a comma.}

\item{log}{Whether to log the creation of the format catalog.  Default is
TRUE. This parameter is used internally.}
}
\value{
The format catalog object.
}
\description{
A format catalog is a collection of formats.  A format
collection allows you to manage and store formats as a unit.  The 
\code{fcat} function defines the format catalog.
}
\details{
A format catalog is an S3 object of class "fcat".  The purpose of 
the catalog is to combine related formats, and allow you to manipulate all
of them as a single object.  The format catalog can be saved to/from a file 
using the \code{\link{write.fcat}} and \code{\link{read.fcat}} functions. 
A format catalog can also 
be converted to/from a data frame using the \code{\link{as.fcat.data.frame}}
and \code{\link{as.data.frame.fcat}} functions.  Formats are accessed in the
catalog using list syntax. 

A format catalog can be used to assign formats to a data frame
or tibble using the \code{\link{formats}} function. Formats may be applied
using the \code{\link{fdata}} and \code{\link{fapply}} functions.

A format catalog may contain any type of format except a formatting list.
Allowed formats include a formatting string, a named vector lookup, a 
user-defined format, and a vectorized formatting function.  A formatting 
list can be converted to a format catalog and saved independently.  See the 
\code{\link{flist}} function for more information on formatting lists.
}
\examples{
# Create format catalog
c1 <- fcat(num_fmt  = "\%.1f",
           label_fmt = value(condition(x == "A", "Label A"),
                             condition(x == "B", "Label B"),
                             condition(TRUE, "Other")),
           date_fmt = "\%d\%b\%Y")

# Use formats in the catalog
fapply(2, c1$num_fmt)
fapply(c("A", "B", "C", "B"), c1$label_fmt)
fapply(Sys.Date(), c1$date_fmt)
}
\seealso{
\code{\link{formats}} function for assigning formats to a data 
frame, and the \code{\link{fdata}} and \code{\link{fapply}} functions for
applying formats.

Other fcat: 
\code{\link{as.data.frame.fcat}()},
\code{\link{as.fcat.data.frame}()},
\code{\link{as.fcat.fmt_lst}()},
\code{\link{as.fcat.list}()},
\code{\link{as.fcat}()},
\code{\link{is.fcat}()},
\code{\link{print.fcat}()},
\code{\link{read.fcat}()},
\code{\link{write.fcat}()}
}
\concept{fcat}
