% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/money-class.R
\name{SingleCurrencyMoney}
\alias{SingleCurrencyMoney}
\title{SingleCurrencyMoney}
\usage{
SingleCurrencyMoney(value, currency)
}
\arguments{
\item{value}{a numeric vector of values}

\item{currency}{a single \link[=Currency]{Currency} object}
}
\value{
a \code{SingleCurrencyMoney} object
}
\description{
This class associates a numeric vector with a currency. This is useful for
example in representing the value of a derivative. You can concatenate a set
\code{SingleCurrencyMoney} objects and return a
\link[=MultiCurrencyMoney]{MultiCurrencyMoney} object (see example below)
}
\examples{
SingleCurrencyMoney(1:5, AUD())
c(SingleCurrencyMoney(1, AUD()), SingleCurrencyMoney(100, USD()))
}
\seealso{
Other money functions: \code{\link{CashFlow}},
  \code{\link{MultiCurrencyMoney}},
  \code{\link{is.CashFlow}},
  \code{\link{is.MultiCurrencyMoney}},
  \code{\link{is.SingleCurrencyMoney}}
}
