% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fm_index_create}
\alias{fm_index_create}
\title{Construct new FM Index}
\usage{
fm_index_create(strings, case_sensitive = FALSE)
}
\arguments{
\item{strings}{Vector of strings (corpus) to construct FM index from}

\item{case_sensitive}{Build case-sensitive index if TRUE}
}
\value{
A FM Index object that can be passed to \code{\link[=fm_index_locate]{fm_index_locate()}} for
finding matches in the corpus.
}
\description{
FM indices are data structures for memory efficient storage of large
sets of strings (corpus). Searches for partial matches with the corpus are
extremely fast.
}
\examples{
data("state")
index <- fm_index_create(state.name, case_sensitive = FALSE)

}
\seealso{
Other FM Index functions: 
\code{\link{fm_index_locate}()},
\code{\link{fm_index_save}()}
}
\concept{FM Index functions}
