% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-slopes30lin_flag.R
\docType{data}
\name{slopes30lin_flag}
\alias{slopes30lin_flag}
\title{Slopes for each flux}
\format{
A tibble with 1251 rows and 22 variables
\describe{
\item{datetime}{Datetime at which CO2 concentration was recorded.}
\item{temp_air}{Air temperature inside the flux chamber in Celsius.}
\item{temp_soil}{Ground temperature inside the flux chamber in Celsius.}
\item{f_conc}{CO2 concentration in ppm.}
\item{PAR}{Photosynthetically active radiation inside the chamber
in micromol/s/sqm.}
\item{turfID}{Unique ID of the turf in which the measurement took place.}
\item{type}{Type of measurement: ecosystems respiration (ER)
or net ecosystem exchange (NEE).}
\item{start}{Datetime at which the measurement was started.}
\item{end}{Datetime at which the measurement ended.}
\item{f_fluxID}{Unique ID for each flux.}
\item{n_conc}{Number of data point per flux.}
\item{ratio}{Ratio of n_conc over length of the measurement (in seconds).}
\item{flag}{Data quality flags.}
\item{time}{Time variable of the flux in seconds.}
\item{cut}{Indicating if the measurement should be kept (keep)
or discarded (cut).}
\item{f_pvalue}{P-value of the linear model of CO2 concentration over time.}
\item{f_rsquared}{R squared of the linear model of CO2 concentration
over time.}
\item{adj.r.squared}{Adjusted R squared of the linear model of CO2
concentration over time.}
\item{intercept}{Intercept of the linear model of CO2 concentration
over time.}
\item{f_slope}{Slope of the linear model of CO2 concentration over time.}
\item{fit}{Output of the linear model of CO2 concentration over time.}
\item{f_start_error}{flagging if measurement started outside of the possible
ambient concentration}
\item{f_quality_flag}{quality flag advising if the slope has to be replaced
by 0 or NA}
\item{f_slope_corr}{slope corrected according to quality flag}
}
}
\usage{
slopes30lin_flag
}
\description{
Slopes of linear fit for each flux with 30 seconds end cut,
with quality flags.
}
\examples{
slopes30lin_flag
}
\keyword{datasets}
