% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluxible-package.R
\docType{package}
\name{fluxible-package}
\alias{fluxible}
\alias{fluxible-package}
\title{fluxible: Ecosystem Gas Fluxes Calculations for Closed Loop Chamber Setup}
\description{
Processes the raw data from closed loop flux chamber (or tent) setups into ecosystem gas fluxes usable for analysis. It goes from a data frame of gas concentration over time (which can contain several measurements) and a meta data file indicating which measurement was done when, to a data frame of ecosystem gas fluxes including quality diagnostics. Functions provided include different models (exponential as described in Zhao et al (2018) \doi{10.1016/j.agrformet.2018.08.022}, quadratic and linear) to estimate the fluxes from the raw data, quality assessment, plotting for visual check and calculation of fluxes based on the setup specific parameters (chamber size, plot area, ...).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://plant-functional-trait-course.github.io/fluxible/}
}

}
\author{
\strong{Maintainer}: Joseph Gaudard \email{joseph.gaudard@pm.me} (\href{https://orcid.org/0000-0002-6989-7624}{ORCID})

Authors:
\itemize{
  \item Paul Efren \email{paulefrens@gmail.com}
  \item Michael Mustri \email{mustrim@arizona.edu}
  \item Pekka O Niittynen \email{pekka.niittynen@helsinki.fi}
  \item Richard James Telford \email{richard.telford@uib.no} (\href{https://orcid.org/0000-0001-9826-3076}{ORCID})
}

}
\keyword{internal}
