% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qaqc.R
\name{ffi_qaqc}
\alias{ffi_qaqc}
\title{Generate a QA/QC document}
\usage{
ffi_qaqc(
  flux_data,
  group_column,
  output_file = "qaqc.html",
  output_dir = getwd(),
  open_output = TRUE
)
}
\arguments{
\item{flux_data}{A data frame from \code{\link{ffi_compute_fluxes}} or similar}

\item{group_column}{Name of the grouping label column in \code{flux_data},
character; pass NULL to run with no grouping}

\item{output_file}{Name of the output file}

\item{output_dir}{Name of the output directory; default is current working directory}

\item{open_output}{Automatically open the output HTML file?}
}
\value{
The path of the output file.
}
\description{
Generate a QA/QC document
}
\examples{
# Toy data
cars$Plot <- c("A", "B")
fd <- ffi_compute_fluxes(cars, "Plot", "speed", "dist")
x <- ffi_qaqc(fd, group_column = "Plot")
file.remove(x) # clean up
# See the introductory vignette for a fully-worked example with real data
}
