% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_unknown_mods.R
\name{get_unknown_mods}
\alias{get_unknown_mods}
\title{Check of converted modifications}
\usage{
get_unknown_mods(input_string, pattern_start, pattern_end)
}
\arguments{
\item{input_string}{character column traceR_precursor as string.}

\item{pattern_start}{character of software-dependent beginning of representation of modifications.}

\item{pattern_end}{character of software-dependent end of representation of modifications.}
}
\value{
This function returns vector with logical values. This function is incorporated in the functions convert_precursor and convert_modified_peptides; used to generate the unknownMods column : if TRUE: a modification is detected, which is not converted to a standardized text.
}
\description{
Check if conversion to UniMod-format of identified modifications is successful.
}
\details{
After conversion to standardized format by convert_precursor or convert_modified_peptides, entries with modifications are checked for a successful conversion. Conversion of modifications is currently only available for UniMod:35 and UniMod:4. Other modifications will not be converted to standardized format.
}
\examples{
# Load libraries
library(dplyr)
library(stringr)
library(tibble)

# Generate data
data <- tibble::tibble(
  "traceR_precursor" = c("AACLLPK",
   "ALTDM(UniMod:35)PQM(UniMod:35)R2",
   "ALTDM(DummyModification)PQMK3")
)

# Unknown modifications present?
get_unknown_mods(input_string = data$traceR_precursor, pattern_start= "(", pattern_end = ")")
}
\author{
Oliver Kardell
}
