% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_proteingroups.R
\name{convert_proteingroups}
\alias{convert_proteingroups}
\title{Conversion of software specific proteinGroups}
\usage{
convert_proteingroups(
  input_df,
  software = c("MaxQuant", "DIA-NN", "Spectronaut", "PD")
)
}
\arguments{
\item{input_df}{A tibble with proteinGroup level information. For MaxQuant: proteinGroups.txt, for PD: PSMs.txt with R-friendly headers enabled, for DIA-NN and Spectronaut default output reports.}

\item{software}{The used analysis software for the input_df - MaxQuant, PD, DIA-NN or Spectronaut. Default is MaxQuant.}
}
\value{
This function returns the original submitted \code{tibble} - input_df - including one new column:
\itemize{
\item traceR_proteinGroups - software-independent standardized text for proteinGroups.
}
}
\description{
ProteinGroups are converted to a common text representation
}
\details{
The input entries are converted to a software independent format. The generated entries are appended to the submitted dataframe.
}
\examples{
# Load libraries
library(dplyr)
library(stringr)
library(comprehenr)
library(tibble)

# MaxQuant example data
data <- tibble::tibble(
"Protein IDs" = c("A0A075B6P5;P01615;A0A087WW87;P01614;A0A075B6S6", "P02671", "P02672"),
id = c(26, 86, 17)
)

# Conversion
convert_proteingroups(
 input_df = data,
 software = "MaxQuant"
)
}
\author{
Oliver Kardell
}
