% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_connected_levels.R
\name{analyze_connected_levels}
\alias{analyze_connected_levels}
\title{Analysis of connected levels}
\usage{
analyze_connected_levels(
  input_df,
  connected_levels = c("proteinGroup_precursor", "mod.peptides_precursor"),
  count_level = c("upper", "lower"),
  plot = TRUE,
  plot_characteristic = c("absolute", "relative")
)
}
\arguments{
\item{input_df}{A tibble with flowTraceR´s connected level information e.g. traceR_connected_pg_prec.}

\item{connected_levels}{Choose either \code{proteinGroup_precursor} or \code{mod.peptides_precursor} for the corresponding traceR connection. Default is proteinGroup_precursor.}

\item{count_level}{Counts appearances per possible connections. Choose either \code{upper} or \code{lower} - lower is always precursor level; upper is either proteingroup or mod.peptide level depending on chosen \code{connected_levels}. Default is upper. Duplicate entries are removed.}

\item{plot}{Logical value, default is TRUE. If \code{TRUE} barplot is generated, if \code{FALSE} report as output.}

\item{plot_characteristic}{if \code{absolute} the absolute count is displayed in barplot, if \code{relative} the relative count is displayed in barplot. Default is absolute. \code{plot_characteristic} has no influence on report.}
}
\value{
This function returns a plot - absolute/relative counts - or a data frame.
}
\description{
Analysis of the traceR_connected_pg_prec or traceR_connected_mod.pep_prec column
}
\details{
Shows the absolute and relative counts of possible connections - unique_unique/unique_common/common_unique/common_common of the respective column - as report or plot.
}
\examples{
# Load libraries
library(dplyr)
library(stringr)
library(ggplot2)
library(tibble)

# DIA-NN example data
data <- tibble::tibble(
  "traceR_connected_pg_prec" = c("common_common", "common_unique", "unique_common"),
  "traceR_traced_proteinGroups" = c("common", "common", "unique"),
  "traceR_traced_mod.peptides" = c("common", "unique", "common"),
  "traceR_traced_precursor" = c("common", "unique", "common"),
  "traceR_proteinGroups" = c("P02768", "P02671", "Q92496"),
  "traceR_precursor" = c("AAC(UniMod:4)LLPK1", "RLEVDIDIK2", "EGIVEYPR2")
)

# Upper level - proteingroup level - how many proteingroups have a specific categorization
# Plot
analyze_connected_levels(input_df = data,
 connected_levels = "proteinGroup_precursor",
 count_level = "upper",
 plot = TRUE,
 plot_characteristic = "relative")

#Report
analyze_connected_levels(input_df = data,
 connected_levels = "proteinGroup_precursor",
 count_level = "upper",
 plot = FALSE)
}
\author{
Oliver Kardell
}
