% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_by_vernacular.R
\name{select_by_vernacular}
\alias{select_by_vernacular}
\title{Search for taxa using vernacular names}
\usage{
select_by_vernacular(data, names, exact = FALSE)
}
\arguments{
\item{data}{(data.frame) the data.frame imported with the
\code{\link{load_florabr}} function or generated with the function
\code{\link{select_species}}.}

\item{names}{(character) vernacular name ("Nome comum") of the species to be
searched}

\item{exact}{(logic) if TRUE, the function will search only for exact
matches. For example, if names = "pinheiro" and exact = TRUE, the function
will return only the species popularly known as "pinheiro". On the other
hand, if names = "pinheiro" and exact = FALSE, the function will return
other results as "pinheiro-do-parana". Default = FALSE}
}
\value{
a data.frame with the species with vernacular names that match the
input names
}
\description{
Search for taxa using vernacular names
}
\examples{
data("bf_data") #Load Brazilian Flora data
#Search for species whose vernacular name is 'pinheiro'
pinheiro_exact <- select_by_vernacular(data = bf_data,
                                       names = "pinheiro",
                                       exact = TRUE)
pinheiro_exact
#Search for species whose vernacular name is 'pinheiro', allowing non-exact
#matches
pinheiro_not_exact <- select_by_vernacular(data = bf_data,
                                          names = "pinheiro",
                                          exact = FALSE)
head(pinheiro_not_exact)

}
\references{
Brazilian Flora 2020. Jardim Botânico do Rio de Janeiro. Available at:
http://floradobrasil.jbrj.gov.br/

Brazilian Flora 2020. Jardim Botânico do Rio de Janeiro. Available at:
http://floradobrasil.jbrj.gov.br/
}
