% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{getLpDistance}
\alias{getLpDistance}
\title{A \eqn{l_p^p} Distance Vector Calculator}
\usage{
getLpDistance(X, p)
}
\arguments{
\item{X}{The \eqn{N \times P} real matrix}

\item{p}{The power p of \eqn{l_p^p}, i.e., \eqn{||x||_p^p = (x_1^p+...x_n^p)}}
}
\value{
A length \eqn{{N \choose 2}} vector of pairwise \eqn{l_p^p} distances
}
\description{
Computes all pairwise \eqn{l_p^p} distances for a real matrix \eqn{\mathbf{X}},
for a specified choice of Minkowski norm exponent \eqn{p}.
}
\details{
Dependencies: lp_distance from fast_dist_calc.cpp
}
\examples{
X <- matrix(nrow = 5, ncol = 10, rnorm(50))
getLpDistance(X, p = 2)

}
