% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{blockLargeP}
\alias{blockLargeP}
\title{Approximate p-value for Test of Exchangeability (Assuming Large P with Block Dependencies)}
\usage{
blockLargeP(X, block_boundaries, block_labels, p = 2)
}
\arguments{
\item{X}{The binary or real matrix on which to perform test of exchangeability}

\item{block_boundaries}{Vector denoting the positions where a new
block of non-independent features starts.}

\item{block_labels}{Length \eqn{P} vector recording the block label of each feature.}

\item{p}{The power \eqn{p} of \eqn{l_p^p}, i.e., \eqn{||x||_p^p = (x_1^p+...x_n^p)}}
}
\value{
The asymptotic p-value
}
\description{
Computes the large \eqn{P} asymptotic p-value for dataset \eqn{\mathbf{X}},
assuming its \eqn{P} features are independent within specified blocks.
}
\details{
This is the large \eqn{P} asymptotics of the permutation test.

Dependencies: getBinVStat, getRealVStat, getChi2Weights, weightedChi2P, getBlockCov
}
