% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_airfares.R
\name{read_airfares}
\alias{read_airfares}
\title{Download data on airfares flights in Brazil}
\usage{
read_airfares(
  date = 202001,
  domestic = TRUE,
  showProgress = TRUE,
  select = NULL
)
}
\arguments{
\item{date}{Numeric. Date of the data in the format \code{yyyymm}. Defaults to
\code{202001}. To download the data for all months in a year, the user
can pass a 4-digit year input \code{yyyy}. The function also accepts a
vector of dates, like \code{c(202201, 202301)} or \code{c(2022, 2024)}.}

\item{domestic}{Logical. Defaults to \code{TRUE} download airfares of domestic
flights. If \code{FALSE}, the function downloads airfares of
international flights.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress.}

\item{select}{A vector of column names or positions to keep. The rest of the
columns are not read. The order that the columns passed determines the
order of the columns in the result.}
}
\value{
A \verb{"data.table" "data.frame"} object. All columns are returned with
\code{class} of type \code{"character"}.
}
\description{
Download data on air fares of domestic and international flights in Brazil.
The data is collected by Brazil’s Civil Aviation Agency (ANAC). A description
of all variables included in the data for domestic airfares is available at
\url{https://www.anac.gov.br/acesso-a-informacao/dados-abertos/areas-de-atuacao/voos-e-operacoes-aereas/tarifas-aereas-domesticas/46-tarifas-aereas-domesticas}.
A description of all variables included in the data for international airfares
is available at \url{https://www.gov.br/anac/pt-br/assuntos/dados-e-estatisticas/microdados-de-tarifas-aereas-comercializadas}.
}
\examples{
\dontrun{ if (interactive()) {
# Read air fare data
af_201506 <- read_airfares(date = 201506, domestic = TRUE)

af_2015 <- read_airfares(date = 2015, domestic = TRUE)
}}
}
\concept{download air fares data}
