% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-preprocess-grid.R
\name{preprocess_grid}
\alias{preprocess_grid}
\title{Preprocess the data for the DEGURBA grid cell classification}
\usage{
preprocess_grid(
  directory,
  filenames = c("BUILT_S.tif", "POP.tif", "LAND.tif"),
  rescale_land = TRUE,
  rescale_built = TRUE
)
}
\arguments{
\item{directory}{character. Path to the directory where the three input grids are saved (for example generated by the function \code{\link[=download_GHSLdata]{download_GHSLdata()}})}

\item{filenames}{vector of length 3 with the filenames of the built-up area, population and land grid}

\item{rescale_land}{logical. Whether to rescale the values of the land grid (see details)}

\item{rescale_built}{logical. Whether to rescale the values of the built-up area grid (see details)}
}
\value{
named listed with the required data to execute the grid cell classification procedure. The list contains following elements:
\itemize{
\item \code{built}: built-up area grid
\item \code{pop}: population grid
\item \code{land}: land grid
\item \code{pop_per_land}: population per area of permanent land
\item \code{built_per_land}: built-up area per permanent land
\item \code{metadata_BUILT_S}: the metadata of the built-up area grid
\item \code{metadata_POP}: the metadata of the population grid
\item \code{metadata_LAND}: the metadata of the land grid.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{preprocess_grid()} has been renamed to \code{DoU_preprocess_grid()} to create a more consistent API and to better indicate that this function is specifically designed for preprocessing the grid data to reconstruct the DEGURBA classification with \code{DoU_classify_grid()}.
}
\keyword{internal}
